from .base import BaseDomenatorException


class MailUserDomainsMultipleNotAllowed(BaseDomenatorException):
    status_code = 409

    def to_json(self):
        return {
            'result': 'error',
            'error': 'multiple_domains_not_allowed'
        }


class MailUserDomainNotRegistered(BaseDomenatorException):
    status_code = 404

    def to_json(self):
        return {
            'result': 'error',
            'error': 'not_registered'
        }
