from .base import BaseDomenatorException


class RegruException(BaseDomenatorException):
    def __init__(self, *, status_code=500, code='OTHER'):
        super().__init__()
        self.code = code
        self.status_code = status_code

    def to_json(self):
        return {
            'result': 'error',
            'error': self.code
        }
