from async_clients.clients.fouras import Client as FourasClient

from intranet.domenator.src.settings import config
from intranet.domenator.src.logic.tvm2 import get_service_ticket
from intranet.domenator.src.domenator_logging.middleware.profiling_client import ProfilingClientMixin


class FourasProfilingClient(FourasClient, ProfilingClientMixin):
    CLIENT_NAME = 'fouras'


async def get_fouras_client() -> FourasProfilingClient:
    return FourasProfilingClient(
        host=config.fouras_host,
        service_ticket=await get_service_ticket(config.fouras_tvm2_client)
    )
