from async_clients.clients.gendarme import Client as GendarmeClient

from intranet.domenator.src.settings import config
from intranet.domenator.src.logic.tvm2 import get_service_ticket
from intranet.domenator.src.domenator_logging.middleware.profiling_client import ProfilingClientMixin


class GendarmeProfilingClient(GendarmeClient, ProfilingClientMixin):
    CLIENT_NAME = 'gendarme'


async def get_gendarme_client() -> GendarmeProfilingClient:
    return GendarmeProfilingClient(
        host=config.gendarme_host,
        service_ticket=await get_service_ticket(config.gendarme_tvm2_client)
    )
