from async_clients.clients.mailsettings import Client as MailSettingsClient

from intranet.domenator.src.settings import config
from intranet.domenator.src.logic.tvm2 import get_service_ticket
from intranet.domenator.src.domenator_logging.middleware.profiling_client import ProfilingClientMixin


class MailSettingsProfilingClient(MailSettingsClient, ProfilingClientMixin):
    CLIENT_NAME = 'mail_settings'


async def get_mailsettings_client() -> MailSettingsProfilingClient:
    return MailSettingsProfilingClient(
        host=config.mailsettings_host,
        service_ticket=await get_service_ticket(config.mailsettings_tvm2_client)
    )
