from async_clients.clients.regru import Client as RegruClient

from intranet.domenator.src.settings import config
from intranet.domenator.src.logic.tvm2 import get_service_ticket
from intranet.domenator.src.domenator_logging.middleware.profiling_client import ProfilingClientMixin


class RegruProfilingClient(RegruClient, ProfilingClientMixin):
    CLIENT_NAME = 'regru'


REGRU_ERRORS_BAD_INPUT = (
    'INVALID_DOMAIN_NAME_FORMAT',
    'INVALID_DOMAIN_NAME_PUNYCODE',
    'DOMAIN_BAD_NAME',
    'DOMAIN_BAD_NAME_ONLYDIGITS',
    'HAVE_MIXED_CODETABLES',
    'DOMAIN_NAME_MUSTBEENG',
    'DOMAIN_ALREADY_EXISTS',
    'DOMAIN_INVALID_LENGTH',
    'DOMAIN_STOP_LIST',
    'DOMAIN_STOP_PATTERN',
    'FREE_DATE_IN_FUTURE',
    'INVALID_PUNYCODE_INPUT',
)

REGRU_ERRORS_UNAVAILABLE = (
    'SERVICE_UNAVAILABLE',
    'CONNECTION_FAILED'
)


async def get_regru_client() -> RegruProfilingClient:
    return RegruProfilingClient(
        host=config.regru_config['host'],
        username=config.regru_config['username'],
        password=config.regru_config['password'],
        contacts=config.regru_config['contacts'],
        # CHEMODAN-76405
        use_zora=True,
        service_ticket=await get_service_ticket(config.gozora_tvm2_client)
    )
