from async_clients.clients.sender import Client as SenderClient

from intranet.domenator.src.settings import config
from intranet.domenator.src.logic.tvm2 import get_service_ticket
from intranet.domenator.src.domenator_logging.middleware.profiling_client import ProfilingClientMixin

ACCOUNT_SLUG = 'Yandex.Mail'


class SenderProfilingClient(SenderClient, ProfilingClientMixin):
    CLIENT_NAME = 'sender'


async def get_sender_client() -> SenderProfilingClient:
    return SenderProfilingClient(
        host=config.sender_host,
        service_ticket=await get_service_ticket(config.sender_tvm2_client)
    )

WEEK_BEFORE_CAMPAIGN_SLUG = 'OWL01UY3-BFT'
# https://sender.yandex-team.ru/Yandex.Mail/campaign/462368/edit/body


async def send_week_before_mail(to_email=None, to_yandex_puid=None, email=None):
    return await send_userdomain_mail(
        campaign_slug=WEEK_BEFORE_CAMPAIGN_SLUG,
        to_email=to_email,
        to_yandex_puid=to_yandex_puid,
        email=email
    )


CANCELLED_DOMAIN_CAMPAIGN_SLUG = 'GCBY0UY3-19N'
# https://sender.yandex-team.ru/Yandex.Mail/campaign/462367/edit/body


async def send_cancelled_domain_mail(to_email=None, to_yandex_puid=None, email=None):
    return await send_userdomain_mail(
        campaign_slug=CANCELLED_DOMAIN_CAMPAIGN_SLUG,
        to_email=to_email,
        to_yandex_puid=to_yandex_puid,
        email=email
    )

REGISTERED_DOMAIN_CAMPAIGN_SLUG = 'W2NRZTY3-WT8'
# https://sender.yandex-team.ru/Yandex.Mail/campaign/462354/edit/body


async def send_registered_domain_mail(to_email=None, to_yandex_puid=None, email=None):
    return await send_userdomain_mail(
        campaign_slug=REGISTERED_DOMAIN_CAMPAIGN_SLUG,
        to_email=to_email,
        to_yandex_puid=to_yandex_puid,
        email=email
    )


async def send_userdomain_mail(campaign_slug=None, to_email=None, to_yandex_puid=None, email=None):
    if to_yandex_puid not in config.mail_allowed_uids:
        return

    if email is None:
        raise Exception('email should be provided')

    if campaign_slug is None:
        raise Exception('campaign_slug should be provided')

    sender = await get_sender_client()

    return await sender.send_transactional(
        account_slug=ACCOUNT_SLUG,
        campaign_slug=campaign_slug,
        to_email=to_email,
        to_yandex_puid=to_yandex_puid,
        args={
            'email': email
        }
    )
