from typing import Optional

from tvm2.aio.thread_tvm2 import TVM2 as TVM2Thread

from intranet.domenator.src.settings import config


def get_tvm2_client() -> TVM2Thread:
    return TVM2Thread(
        client_id=config.tvm2_client,
        secret=config.tvm2_secret.get_secret_value(),
        blackbox_client=config.tvm2_blackbox_client,
        allowed_clients=config.tvm2_allowed_clients,
    )


# for some reason without this line client.get_service_ticket
# in get_service_ticket resolves to
# https://a.yandex-team.ru/arc/trunk/arcadia/library/python/tvm2/tvm2/protocol.py?rev=r7035598#L92
# https://st.yandex-team.ru/CHEMODAN-76581
try:
    client = get_tvm2_client()
except Exception:
    pass


async def get_service_ticket(client_id: str) -> Optional[str]:
    client = get_tvm2_client()
    return await client.get_service_ticket(client_id)
