import os
import subprocess

from intranet.domenator.src.db.engine import db, get_engine_config
from .settings import config


def dbshell():

    pgshell = os.environ.get('PGSHELL', 'pgcli')

    db_settings = {
        'user': config.db_username,
        'password': config.db_password,
        'host': config.db_master_host,
        'port': config.db_port,
        'database': config.db_name,
        'sslmode': config.db_sslmode,
    }

    command = ''

    if db_settings.get('password'):
        command = 'PGPASSWORD={password} '.format(
            password=db_settings.get('password'))

    target_session_attrs_opt = 'target_session_attrs=read-write'

    command += (
        '{pgshell} -d "'
        'host={host} '
        'port={port} '
        'sslmode={sslmode} '
        'dbname={database} '
        'user={user} '
        '{target_session_attrs_opt}"'
    ).format(
        pgshell=pgshell,
        target_session_attrs_opt=target_session_attrs_opt,
        **db_settings
    )
    subprocess.call(command, shell=True)


async def bind_db():
    # for usage in shell only
    engine_kwargs = get_engine_config()
    bind = engine_kwargs['dsn']
    echo = engine_kwargs['echo']
    ssl = engine_kwargs['ssl']
    kwargs = engine_kwargs['kwargs']
    await db.set_bind(bind=bind, echo=echo, ssl=ssl, **kwargs)
