import os

from fastapi import Request

from .settings import config
from .logic.exceptions.yauth import NoAuthException
from .logic.exceptions.exception_handler import base_exception_handler


async def yauth_require(request: Request, call_next):
    """
    Возвращаем 401 если пользователь не авторизован
    и запрос не сделан в тестинге через swagger
    """
    if request.user.is_authenticated() or no_auth_required(request):
        return await call_next(request)

    return await base_exception_handler(
        request=request,
        exc=NoAuthException(reason=request.user.reason),
    )


def no_auth_required(request: Request) -> bool:
    path = request.url.path
    if config.env_type == 'testing' and request.headers.get('referer') == f'http://domenator-test.yandex.net{config.docs_prefix}/swagger':
        return True

    # for local developing
    if config.env_type == 'development' and os.getenv('DOCKER'):
        return True

    return path in (config.ping_path,) or path.startswith(config.docs_prefix)
