from arq import create_pool
from arq.connections import RedisSettings

from intranet.domenator.src.settings import config


def get_redis_settings():
    if config.redis_sentinel:
        sentinel_host = [(h, config.redis_port)
                         for h in config.redis_host.split(',')]
        return RedisSettings(
            host=sentinel_host,
            sentinel=True,
            sentinel_master=config.redis_sentinel_master,
            password=config.redis_password,
        )
    else:
        return RedisSettings(
            host=config.redis_host,
            port=config.redis_port,
        )


async def create_redis_pool():
    return await create_pool(
        settings_=get_redis_settings(),
        default_queue_name=config.redis_queue_name,
    )
