import os

from pydantic import Field, SecretStr
from typing import List
from .base import Settings as BaseSettings


class Settings(BaseSettings):
    debug: bool = True

    registrar_get_token_secret: bytes = b'$ecret' + 10 * b'0'
    registrar_store_token_secret: bytes = b'$ecret' + 10 * b'0'
    registrar_store_password_secret: bytes = b'$ecret' + 10 * b'0'

    tvm2_client: str = '28'
    tvm2_allowed_clients: List[int] = [2000324, 2006051, 2006177]
    tvm2_secret: SecretStr = os.getenv('TVM2_SECRET', 'secret')
    mail_allowed_uid: List[str] = ['1395159824', '1395382591', '1409942665']

    db_username: str = Field('postgres', env='PG_LOCAL_USER')
    db_password: str = Field('postgres', env='PG_LOCAL_PASSWORD')
    db_name: str = Field('domenator', env='PG_LOCAL_DATABASE')
    db_port: int = Field(5432, env='PG_LOCAL_PORT')
    db_raw_host: str = Field('localhost', env='PG_LOCAL_HOST')
    db_master_host: str = Field('localhost', env='PG_LOCAL_HOST')
    db_ssl: bool = False
    db_echo: bool = True
    db_sslmode: str = 'disable'

    redis_sentinel = False
    redis_host = Field('localhost', env='REDIS_HOST')

    enable_domain_sync: bool = False
    enable_logbroker_task: bool = False
    enable_renew_domains: bool = False
    enable_expired_at: bool = False
