import asyncio

from intranet.domenator.src.worker.utils import job
from intranet.domenator.src.domenator_logging.logger import get_logger

default_log = get_logger(log_name='dom_default')


@job
async def test_task(ctx):
    default_log.info('Test task is running...')
    await asyncio.sleep(1)
    await ctx['redis'].enqueue_job('nested_test_task')
    default_log.info('Test task is completed.')


@job
async def nested_test_task(ctx):
    default_log.info('Nested test task is running...')
    await asyncio.sleep(1)
    default_log.info('Nested test task is completed.')
