import uuid
import os
from functools import wraps

from intranet.domenator.src.domenator_logging.logger import get_logger
from intranet.domenator.src.domenator_logging.middleware.arq import arq_log_context

error_log = get_logger(log_name='dom_error')
default_log = get_logger(log_name='dom_default')


def job(func):
    @wraps(func)
    async def wrapper(ctx, ycrid=None, *args, **kwargs):
        ctx['ycrid'] = ycrid or f'domenator-{uuid.uuid4().hex}-{os.environ.get("DEPLOY_POD_PERSISTENT_FQDN", "")}'
        with arq_log_context(func, ctx):
            result = await func(ctx, *args, **kwargs)
        return result

    wrapper.arq_config = {
        'is_cron': False
    }
    return wrapper


def periodic_job(predicate=True, **cron_kwargs):
    def decorator(func):
        @wraps(func)
        async def wrapper(ctx, *args, **kwargs):
            ycrid = f'domenator-{uuid.uuid4().hex}-{os.environ.get("DEPLOY_POD_PERSISTENT_FQDN", "")}'
            ctx['ycrid'] = ycrid
            with arq_log_context(func, ctx):
                try:
                    result = await func(ctx, *args, **kwargs)
                    default_log.info(f'Task domenator_{func.__name__}/{ycrid} completed successfully')
                except Exception:
                    default_log.error(f'Task domenator_{func.__name__}/{ycrid} failed')
                    default_log.exception('Exception:\n', exc_info=True)

                    raise
            return result

        wrapper.arq_config = {
            'is_cron': True,
            'predicate': predicate,
            'cron_kwargs': cron_kwargs,
        }
        return wrapper

    return decorator
