PY3_LIBRARY()

OWNER(g: tools-domenator)

PEERDIR(
    contrib/python/fastapi
    contrib/python/hypercorn
    contrib/python/gino
    contrib/python/ipython
    contrib/python/pycrypto
    contrib/python/dateutil
    contrib/python/arq
    contrib/python/click
    contrib/python/transliterate
    contrib/python/validators
    contrib/python/dnspython
    contrib/python/asyncwhois
    contrib/python/cached-property
    contrib/python/aiofiles

    library/python/asgi_yauth
    library/python/async_clients
    library/python/python-blackboxer
    library/python/pyscopg2
    library/python/ylog

    kikimr/public/sdk/python/persqueue
)

NO_CHECK_IMPORTS(
    hypercorn.*
)

PY_SRCS(
    api/common.py
    api/pagination.py
    api/routes/domain.py
    api/routes/domain_token.py
    api/routes/private/domain.py
    api/routes/registrar.py
    api/schemas/common.py
    api/schemas/domain.py
    api/schemas/domain_token.py
    api/schemas/private/domain.py
    api/schemas/registrar.py
    db/__init__.py
    db/domain/models.py
    db/domain_token/models.py
    db/event/models.py
    db/engine.py
    db/pool.py
    db/registrar/models.py
    logbroker/__init__.py
    logic/cryptography.py
    logic/blackbox.py
    logic/connect.py
    logic/mailsettings.py
    logic/event/__init__.py
    logic/event/events.py
    logic/fouras.py
    logic/gendarme.py
    logic/passport.py
    logic/domain.py
    logic/mail_user_domain.py
    logic/registrar/password.py
    logic/types.py
    logic/exceptions/base.py
    logic/exceptions/common.py
    logic/exceptions/domain.py
    logic/exceptions/exception_handler.py
    logic/exceptions/webmaster.py
    logic/exceptions/yauth.py
    logic/exceptions/regru.py
    logic/exceptions/mail_user_domain.py
    logic/tvm2.py
    logic/webmaster.py
    logic/regru.py
    logic/sender.py
    logic/utils/__init__.py
    logic/utils/credential_sanitizer.py
    logic/dns_resolver.py
    settings/__init__.py
    settings/base.py
    settings/development.py
    settings/preprod.py
    settings/production.py
    settings/testing.py
    worker/periodic_tasks.py
    worker/settings.py
    worker/tasks.py
    worker/utils.py
    app.py
    common_routes.py
    domenator_logging/__init__.py
    domenator_logging/logger.py
    domenator_logging/settings.py
    domenator_logging/middleware/__init__.py
    domenator_logging/middleware/arq.py
    domenator_logging/middleware/base.py
    domenator_logging/middleware/collector.py
    domenator_logging/middleware/http.py
    domenator_logging/middleware/profiling_client.py
    domenator_logging/middleware/providers/__init__.py
    domenator_logging/middleware/providers/arq_job.py
    domenator_logging/middleware/providers/base.py
    domenator_logging/middleware/providers/request.py
    utils/tasks.py
    manage.py
    middleware.py
    redis.py
)

END()
