# coding: utf-8

from __future__ import unicode_literals

from django.contrib import admin

from easymeeting.core import models
from easymeeting.core.offices import OfficeController
from easymeeting.lib import admin as lib_admin
from easymeeting.lib.tvm2_client import get_user_ticket


def collect_offices(modeladmin, request, queryset):
    user_ticket = get_user_ticket(request)
    office_controller = OfficeController(request.yauser.uid, user_ticket)
    return office_controller.collect_offices_from_staff_and_calendar()


collect_offices.short_description = "Replace ALL offices from sources"


class OfficeAdmin(lib_admin.ModelAdminBase):
    list_display = (
        'calendar_id',
        'staff_id',
        'name_ru',
        'name_en',
        'city_name_ru',
        'city_name_en',
    )

    search_fields = list_display
    actions = [collect_offices]


class VisitAdmin(lib_admin.ModelAdminBase):
    list_display = (
        'uid',
        'created_at',
        'params',
        'is_helpful',
    )

    search_fields = list_display


admin.site.register(models.Office, OfficeAdmin)
admin.site.register(models.Visit, VisitAdmin)
