# coding: utf-8

from __future__ import unicode_literals

from django.conf import settings
from ids.registry import registry
from more_itertools import chunked

from easymeeting.lib import datetimes


def get_gaps_chunk(logins, date_from, date_to):
    repo = registry.get_repository(
        service='gap2',
        resource_type='gaps',
        user_agent=settings.SERVICE,
        oauth_token=settings.ROBOT_OAUTH_TOKEN,
        timeout=8,
    )
    gaps = repo.get(
        lookup={
            'person_login': logins,
            'date_from': date_from.isoformat(),
            'date_to': date_to.isoformat(),
        },
    )
    parsed = []
    for gap in gaps:
        item = {}
        for key, value in gap.items():
            if key in ('date_from', 'date_to'):
                value = datetimes.parse_gap_datetime_str(value)
            item[key] = value
        parsed.append(item)
    return parsed


def get_gaps(logins, date_from, date_to):
    logins_chunks = chunked(logins, settings.GAP_LOGINS_CHUNK_SIZE)
    result = []
    for logins_chunk in logins_chunks:
        result += get_gaps_chunk(
            logins=logins_chunk,
            date_from=date_from,
            date_to=date_to,
        )
    return result


def get_persons_gap_by_logins(logins, date_from, date_to):
    persons_gap = get_gaps(
        logins=logins,
        date_from=date_from,
        date_to=date_to,
    )
    persons_gap_by_logins = {}
    for login in logins:
        persons_gap_by_logins[login] = []
    for person_gap in persons_gap:
        if 'person_login' in person_gap:
            login = person_gap['person_login']
            persons_gap_by_logins[login].append(person_gap)
    return persons_gap_by_logins
