# coding: utf-8

from __future__ import unicode_literals

from django.db import models


class Office(models.Model):
    calendar_id = models.IntegerField(
        unique=True,
        null=True,
        blank=True,
    )
    staff_id = models.IntegerField(
        unique=True,
        null=True,
        blank=True,
    )
    name_ru = models.CharField(
        max_length=200,
        blank=True,
    )
    name_en = models.CharField(
        max_length=200,
        blank=True,
    )
    city_name_ru = models.CharField(
        max_length=200,
        blank=True,
    )
    city_name_en = models.CharField(
        max_length=200,
        blank=True,
    )


class Visit(models.Model):
    uid = models.CharField(
        max_length=64,
        help_text='User unique identifier from BlackBox',
    )
    created_at = models.DateTimeField(
        auto_now_add=True,
        help_text='Visiting time',
    )
    params = models.TextField(
        help_text='JSON serialized request params',
    )
    is_helpful = models.NullBooleanField(
        help_text='Is visit helpful for user',
        null=True,
        blank=True,
    )

    class Meta:
        ordering = ['-created_at']
