# coding: utf-8

from __future__ import unicode_literals

import attr


class PersonEvent(object):

    def __init__(self, **kwargs):
        self.event_id = kwargs['eventId']
        self.start = kwargs['start']
        self.end = kwargs['end']
        self.availability = kwargs['availability']


PersonEvent = attr.s(
    these={
        'event_id': attr.ib(),
        'start': attr.ib(),
        'end': attr.ib(),
        'availability': attr.ib(),
    },
    init=False,
)(PersonEvent)


def get_persons_events(calendar_controller, logins, date_from, date_to, tz=None):
    emails = [
        '{}@yandex-team.ru'.format(login)
        for login in logins
    ]
    raw_persons_events = calendar_controller.get_persons_events(
        emails=emails,
        date_from=date_from,
        date_to=date_to,
        tz=tz,
    )
    persons_events = {}
    for raw_person_events in raw_persons_events.get('subjectAvailabilities', []):
        login = get_login_from_email(raw_person_events.get('email', ''))
        persons_events[login] = get_person_events(raw_person_events.get('intervals', []))
    return persons_events


def get_login_from_email(email):
    return email.split('@')[0]


def get_person_events(intervals):
    return [
        PersonEvent(**interval)
        for interval in intervals
    ]
