# coding: utf-8

from __future__ import unicode_literals, division

import attr


@attr.s(frozen=True)
class PersonsAvailability(object):
    available = attr.ib(
        default=attr.Factory(tuple),
        converter=tuple,
    )
    unavailable = attr.ib(
        default=attr.Factory(tuple),
        converter=tuple,
    )

    @property
    def available_count(self):
        return len(self.available)

    @property
    def unavailable_count(self):
        return len(self.unavailable)

    @property
    def total_count(self):
        return self.available_count + self.unavailable_count

    @property
    def availability(self):
        return self.available_count / self.total_count if self.total_count > 0 else 0
