# coding: utf-8

from __future__ import unicode_literals

from easymeeting.lib import datetimes

import attr


@attr.s(frozen=True)
class ResourceEvent(object):
    interval = attr.ib()
    persons_availability = attr.ib(default=None)
    event_id = attr.ib(default=None)

    @classmethod
    def from_raw_event(cls, **kwargs):
        if 'interval' in kwargs:
            interval = kwargs['interval']
        else:
            start = datetimes.parse_calendar_datetime_str(kwargs['start'])
            end = datetimes.parse_calendar_datetime_str(kwargs['end'])
            interval = (start, end)
        return cls(
            interval=interval,
            persons_availability=kwargs.get('persons_availability', None),
            event_id=kwargs.get('eventId', None),
        )
