# coding: utf-8

from __future__ import unicode_literals

from django.conf import settings
from ids.registry import registry

import attr

from easymeeting.lib.tvm2_client import get_service_ticket


@attr.s(frozen=True)
class Room(object):
    id = attr.ib()
    display_name = attr.ib()
    exchange_name = attr.ib()

    @classmethod
    def from_raw_resource(cls, raw_resource):
        info = raw_resource['info']
        id = info['id']
        display_name = info['name']
        exchange_name, domain = info['email'].split('@')
        return cls(
            id=id,
            display_name=display_name,
            exchange_name=exchange_name,
        )


def get_rooms(exchange_names):
    repo = registry.get_repository(
        service='staff',
        resource_type='room',
        user_agent=settings.SERVICE,
        service_ticket=get_service_ticket(settings.STAFF_API_TVM_CLIENT_ID),
        timeout=8,
    )
    result_set = repo.getiter(lookup={
        'name.exchange': ','.join(exchange_names),
        '_fields': ','.join([
            'additional',
            'name',
            'floor.number',
            'equipment',
            'capacity',
            'locations',
        ]),
        '_sort': 'id',
        '_limit': 1000,
    })
    return list(result_set)
