# coding: utf-8

from __future__ import unicode_literals

from django import forms

from easymeeting.lib import views
from easymeeting.core.offices import OfficeController


class OfficesForm(forms.Form):
    officeIds = forms.CharField(required=False)

    def clean_officeIds(self):
        office_ids = self.cleaned_data['officeIds']
        return map(int, office_ids.split(',')) if office_ids else []


class OfficeView(views.View):
    form_cls_get = OfficesForm

    def process_get(self, data):
        office_controller = OfficeController(self.request.yauser.uid, self.user_ticket)
        fetched_offices = office_controller.get_offices(
            office_ids=data['officeIds'],
            language=self.request.yauser.fields.get('language', 'ru'),
        )
        offices_data = map(serialize_office, fetched_offices)
        return {'offices': offices_data}


def serialize_office(office):
    return {
        'id': office.id,
        'name': office.name,
        'cityName': office.city_name,
        'tzOffset': office.tz_offset,
    }
