# coding: utf-8

from __future__ import unicode_literals

from django import forms

from easymeeting.lib import views
from easymeeting.core import rooms


class RoomsForm(forms.Form):
    exchangeNames = forms.CharField()

    def clean_exchangeNames(self):
        return self.cleaned_data['exchangeNames'].split(',')


class RoomView(views.View):
    form_cls_get = RoomsForm

    def process_get(self, data):
        rooms_list = rooms.get_rooms(exchange_names=data['exchangeNames'])
        return {'rooms': rooms_list}
