# coding: utf-8

from __future__ import unicode_literals

import json

from datetime import timedelta
from django.utils import timezone
from django.http import HttpResponse
from django import forms

from easymeeting.lib import views
from easymeeting.core import models


class VisitForm(forms.Form):
    id = forms.IntegerField()
    isHelpful = forms.NullBooleanField()


class VisitView(views.View):
    form_cls_post = VisitForm

    def process_get(self, data):
        one_day_ago = timezone.now() - timedelta(days=1)
        is_recently_answered = models.Visit.objects.filter(
            uid=self.request.yauser.uid,
            is_helpful__isnull=False,
            created_at__gte=one_day_ago,
        ).exists()
        if is_recently_answered:
            return {}

        two_days_ago = timezone.now() - timedelta(days=2)
        last_visit = models.Visit.objects.filter(
            uid=self.request.yauser.uid,
            is_helpful=None,
            created_at__gte=two_days_ago,
        ).order_by(
            '-created_at',
        ).first()
        return serialize(visit=last_visit)

    def process_post(self, data):
        models.Visit.objects.filter(
            id=data['id'],
            uid=self.request.yauser.uid,
        ).update(
            is_helpful=data['isHelpful'],
        )
        return HttpResponse(status=204)


def serialize(visit):
    return {
        'id': visit.id,
        'date': visit.created_at,
        'params': json.loads(visit.params),
    } if visit else {}
