# coding: utf-8

from __future__ import unicode_literals

import yenv

from django.conf import settings
from django.contrib.auth import models as auth_models
from django.db import models


class Person(auth_models.AbstractBaseUser):
    """
    Эта модель только для джанго-админки,
    пока нам не нужны пользователи в базе.
    Потом можем наполнять таблицу, если будет нужно.
    """
    USERNAME_FIELD = 'login'
    EMAIL_FIELD = 'work_email'

    login = models.CharField(
        max_length=50,
        unique=True,
        primary_key=True,
    )
    work_email = models.CharField(
        max_length=100,
        default="",
    )

    @property
    def is_active(self):
        return True

    @property
    def is_staff(self):
        if yenv.type in ('production', 'prestable'):
            return self.login in settings.ADMINS
        else:
            return True

    @property
    def is_superuser(self):
        if yenv.type != 'production':
            return True

    def has_perm(self, perm, obj=None):
        return self.is_staff

    def has_perms(self, perm_list, obj=None):
        return self.is_staff

    def has_module_perms(self, app_label):
        return self.is_staff

    def get_short_name(self):
        return self.login

    def get_full_name(self):
        return self.get_short_name()
