# coding: utf-8

from django.conf import settings
from django.conf.urls import url, include
from django.contrib import admin
from django.http import HttpResponse
from django.views.generic import RedirectView
from django.contrib.staticfiles import views


urlpatterns = [
    url(r'^admin/', admin.site.urls),
    url(r'^frontend/', include('easymeeting.frontend.urls')),
    url(r'^ping/?$', lambda *a, **kw: HttpResponse('ok')),
]


if settings.DEBUG:
    import debug_toolbar
    from debug_panel import urls as debug_urls
    urlpatterns += [

        url(r'^__debug__/', include(debug_toolbar.urls)),

        # annoying error when resolving this
        url(r'^favicon.ico$', RedirectView.as_view()),
        url(r'^static/(?P<path>.*)$', views.serve),

    ] + debug_urls.urlpatterns
