# coding: utf-8
from __future__ import absolute_import

import os
from celery import Celery
from celery import signals

from django import db
from django.conf import settings


os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'fb.settings')

app = Celery('feedback')
app.config_from_object('django.conf:settings')
app.autodiscover_tasks(lambda: settings.INSTALLED_APPS)


@signals.setup_logging.connect
def setup_logging(**kwargs):
    """
    Отключаем настройку логгирования в самом celery
    """
    pass


# Подчищаем протухшие соединения с базой перед каждой таской
signals.task_prerun.connect(db.close_old_connections)
