# coding: utf-8
from __future__ import unicode_literals
import yenv
import logging

from django.conf import settings
from django.core.mail import EmailMessage as DjangoEmailMessage

logger = logging.getLogger(__name__)


class EmailMessage(DjangoEmailMessage):

    content_subtype = 'html'

    def __init__(self, *args, **kwargs):
        super(EmailMessage, self).__init__(*args, **kwargs)

        self.sanitize_recipients()

        if yenv.type != 'production':
            self.body += '<br/>\nOriginal To: {}'.format(self.to)
            if self.cc:
                self.body += '<br>\nCC: {}'.format(self.cc)
            if self.bcc:
                self.body += '<br>\nBCC: {}'.format(self.bcc)

        logger.info(
            'Creating email to: %s, cc: %s. Subject: %s',
            self.to,
            self.cc,
            self.subject,
        )

    def recipients(self):
        if yenv.type != 'production':
            self.to = [settings.DEBUG_EMAIL]
            self.cc = []
            self.bcc = []
            return self.to
        return super(EmailMessage, self).recipients()

    def sanitize_recipients(self):
        banned = set(settings.BANNED_EMAIL_RECIPIENTS)
        to_ban = (set(self.to) | set(self.cc) | set(self.bcc)) & banned
        if to_ban:
            logger.info('Restricting email (%s) to %s', self.subject, list(to_ban))
            self.to = list(set(self.to) - banned)
            self.cc = list(set(self.cc) - banned)
            self.bcc = list(set(self.bcc) - banned)
