# coding: utf-8
from django.conf import settings

from rest_framework import permissions


class OAuthClientPermission(permissions.BasePermission):

    def has_permission(self, request, view):
        if request.yauser.oauth is not None:
            client_id = request.client_application.id
            if client_id not in settings.ALLOWED_OAUTH_CLIENTS:
                return False
        return True
