# -*- coding: utf-8 -*-
from datetime import datetime
import django.template as template
import re
from django.utils.safestring import mark_safe
from django.utils.encoding import smart_unicode
from django.utils.html import conditional_escape
from fb.staff.misc.inflector import get_inflator

register = template.Library()

_first_letter = re.compile(r'^(.*?)(\w|\S(?!.*\w))(.*)$', re.UNICODE | re.DOTALL)


@register.simple_tag
def gender_verb_form(word, gender):
    if gender:
        return word + u"а"
    return word

# From django_russian

def _username(login, html, autoescape=None):
    if not login:
        return mark_safe('')
    match = _first_letter.match(smart_unicode(login))
    if not match:
        if autoescape:
            login = conditional_escape(login)
        return mark_safe(login)
    groups = match.groups()
    if autoescape:
        groups = tuple(map(conditional_escape, groups))
    return mark_safe(html % groups)


@register.filter
def username(login, autoescape=None):
    font_style = {
        u"font-family": u"Arial, Helvetica, sans-serif",
        u"margin": u"0",
        u"color": u"#ff0000",
        u"font-weight": u"normal",
    }

    style = u" ".join(u"%s:%s;" % (k, v) for (k, v) in font_style.iteritems())

    username_template = u'%s<font style="' + style + u'">%s</font>%s'
    return _username(login, username_template, autoescape)

username.needs_autoescape = True


def get_name_cases(user):
    inflator = get_inflator()
    return inflator.get_full_name_cases(user)


@register.filter
def inflate_name_acc(user):
    cases = get_name_cases(user)
    return cases.get('acc', user.get_full_name())


@register.filter
def inflate_name_gen(user):
    cases = get_name_cases(user)
    return cases.get('gen', user.get_full_name())


@register.filter
def smart_join(ss):
    ss = [smart_unicode(i) for i in ss]

    if len(ss) >= 2:
        res = u'%s и %s' % (', '.join(ss[0:-1]), ss[-1])
    elif len(ss) == 1:
        res = ss[0]
    else:
        res = u''

    return res


MONTHS = {
    1: u'января',
    2: u'февраля',
    3: u'марта',
    4: u'апреля',
    5: u'мая',
    6: u'июня',
    7: u'июля',
    8: u'августа',
    9: u'сентября',
    10: u'октября',
    11: u'ноября',
    12: u'декабря',
}


@register.simple_tag
def human_date_interval(from_date, to_date):
    """
    Человеческое обозначение интервала из начальной и конечной дат
    """
    if from_date.year != datetime.now().year:
        year_str = u' %s года' % from_date.year
    else:
        year_str = u''

    if from_date == to_date:
        return u'%s %s' % (from_date.day, MONTHS[from_date.month]) + year_str
    elif from_date.year == to_date.year and from_date.month == to_date.month:
        return u'%s — %s %s' % (
            from_date.day, to_date.day, MONTHS[to_date.month]) + year_str
    elif from_date.year == to_date.year:
        return u'%s %s — %s %s' % (
            from_date.day, MONTHS[from_date.month],
            to_date.day, MONTHS[to_date.month]) + year_str
    else:
        return u'%d.%02d.%d — %d.%02d.%d' % (
            from_date.day, from_date.month, from_date.year,
            to_date.day, to_date.month, to_date.year)
