import django.template as template
from django.utils.translation import ugettext as _
from fb.quizz.models import QuizzQuestion

register = template.Library()

@register.simple_tag
def write_question_type(question_type):
    if question_type == QuizzQuestion.QT_CHECKBOX:
        return "(%s)" % (_("quizz.mail.checkbox"),)
    elif QuizzQuestion.get_question_type_element(question_type) == QuizzQuestion.QTE_TEXT:
        return "(%s)" % (_("quizz.mail.textbox"),)
    elif question_type == QuizzQuestion.QT_RADIO_BUTTON:
        return "(%s)" % (_("quizz.mail.radiobox"),)
    elif question_type == QuizzQuestion.QT_SELECT:
        return "(%s)" % (_("quizz.mail.selectbox"))
    return ''
