# coding: utf-8
from __future__ import unicode_literals

from django.contrib import admin

from fb.feedback import models


@admin.register(models.Feedback)
class FeedbackAdmin(admin.ModelAdmin):

    def get_queryset(self, request):
        queryset = super(FeedbackAdmin, self).queryset(request)
        queryset = queryset.prefetch_related(
            'reporter',
            'persons',
            'blacklisted_persons',
            'personanswer_set',
        )
        return queryset

    list_display = (
        'id',
        'reporter',
        'reporter_type',
        'create_time',
        'change_time',
        'is_changed',
        'is_revoked',
        'persons_logins',
        'blacklisted_persons_logins',
        'person_answers',
    )
    fields = list_display
    readonly_fields = list_display
    list_filter = (
        'reporter_type',
        'is_revoked',
    )
    list_select_related = (

    )
    search_fields = (
        'reporter__login',
        'persons__login',
    )

    def persons_logins(self, obj):
        return ', '.join([
            person.login for person in obj.persons.all()
        ])

    def blacklisted_persons_logins(self, obj):
        return ', '.join([
            person.login for person in obj.blacklisted_persons.all()
        ])

    def person_answers(self, obj):
        return ', '.join([
             str(answer.id) for answer in
             obj.personanswer_set.all()
         ])


@admin.register(models.FeedbackRequest)
class FeedbackRequestAdmin(admin.ModelAdmin):

    def get_queryset(self, request):
        queryset = super(FeedbackRequestAdmin, self).queryset(request)
        queryset = queryset.prefetch_related(
            'suggested_persons',
            'suggest_to',
            'reporter'
        )
        return queryset

    list_display = (
        'id',
        'suggested_persons_logins',
        'suggest_to',
        'reporter',
        'is_submitted',
        'created',
        'deadline'
    )
    fields = list_display
    readonly_fields = list_display
    list_filter = (
        'is_submitted',
    )
    search_fields = (
        'reporter__login',
        'suggest_to__login',
        'suggested_persons__login',
    )

    def suggested_persons_logins(self, obj):
        return ', '.join([
            person.login for person in obj.suggested_persons.all()
        ])
