# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import models, migrations


class Migration(migrations.Migration):

    dependencies = [
        ('staff', '__first__'),
    ]

    operations = [
        migrations.CreateModel(
            name='Feedback',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('reporter_type', models.CharField(max_length=100, choices=[(b'client', b'client'), (b'implementer', b'implementer'), (b'subordinate', b'subordinate'), (b'head', b'head'), (b'partner', b'partner')])),
                ('positive_message', models.TextField()),
                ('negative_message', models.TextField()),
            ],
            options={
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='FeedbackGroup',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('feedback', models.ForeignKey(related_name=b'feedback_group', to='feedback.Feedback')),
                ('person', models.ForeignKey(related_name=b'feedback_group', to='staff.Person')),
            ],
            options={
            },
            bases=(models.Model,),
        ),
        migrations.AddField(
            model_name='feedback',
            name='persons',
            field=models.ManyToManyField(related_name=b'feedbacks', through='feedback.FeedbackGroup', to='staff.Person'),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name='feedback',
            name='reporter',
            field=models.ForeignKey(to='staff.Person'),
            preserve_default=True,
        ),
    ]
