# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import models, migrations


class Migration(migrations.Migration):

    dependencies = [
        ('staff', '0003_person_gender'),
        ('feedback', '0002_feedback_create_time'),
    ]

    operations = [
        migrations.CreateModel(
            name='FeedbackRequest',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('reason', models.TextField(blank=True)),
                ('is_submitted', models.BooleanField(default=False)),
                ('reporter', models.ForeignKey(related_name=b'my_requests', to='staff.Person')),
                ('suggest_to', models.ForeignKey(related_name=b'+', to='staff.Person')),
                ('suggested_persons', models.ManyToManyField(related_name=b'+', to='staff.Person')),
            ],
            options={

            },
            bases=(models.Model,),
        ),
        migrations.AlterField(
            model_name='feedback',
            name='negative_message',
            field=models.TextField(blank=True),
        ),
        migrations.AlterField(
            model_name='feedback',
            name='positive_message',
            field=models.TextField(blank=True),
        ),
        migrations.AlterField(
            model_name='feedback',
            name='reporter',
            field=models.ForeignKey(related_name=b'my_feedback', to='staff.Person'),
        ),
        migrations.AlterField(
            model_name='feedback',
            name='reporter_type',
            field=models.CharField(max_length=100, choices=[(b'client', 'client'), (b'customer', 'customer'), (b'implementer', 'implementer'), (b'subordinate', 'subordinate'), (b'head', 'head'), (b'partner', 'partner')]),
        ),
    ]
