# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import models, migrations


def assign_moods(apps, schema_editor):
    MOOD_NEGATIVE = 0
    MOOD_NEUTRAL = 1
    MOOD_POSITIVE = 2
    Feedback = apps.get_model('feedback', 'Feedback')
    for feedback in Feedback.objects.all():
        negative_message_words_count = len(feedback.negative_message.split())
        positive_message_words_count = len(feedback.positive_message.split())
        mood = MOOD_NEUTRAL
        if negative_message_words_count > 5 and positive_message_words_count < 5:
            mood = MOOD_NEGATIVE
        if positive_message_words_count > 5 and negative_message_words_count < 5:
            mood = MOOD_POSITIVE
        feedback.mood = mood
        feedback.save()

def revert_assign_moods(apps, schema_editor):
    MOOD_NEUTRAL = 1
    Feedback = apps.get_model('feedback', 'Feedback')
    Feedback.objects.update(mood=MOOD_NEUTRAL)


class Migration(migrations.Migration):

    dependencies = [
        ('feedback', '0009_feedback_mood'),
    ]

    operations = [
        migrations.RunPython(assign_moods, revert_assign_moods),
    ]
