from django.conf.urls import patterns, include, url
from fb.feedback import views


urlpatterns = patterns('',
    url(r'^$', views.FeedbackList.as_view(), name='feedback-list'),
    url(r'^(?P<id>\d+)/?$', views.FeedbackDetails.as_view(), name='feedback-details'),
    url(r'^subordinates/persons/?$', views.MySubordinatesDepartmentFeedbackPersonsList.as_view(), name='dep-feedback-persons'),
    url(r'^subordinates/(?P<pk>\d+)/?$', views.MySubordinatesDepartmentFeedbackList.as_view(), name='dep-feedback-list'),
    url(r'^subordinates/(?P<login>[\w-]+)/?$', views.MySubordinatesDepartmentFeedbackList.as_view(), name='dep-feedback-list-by-login'),
    url(r'^subordinates/(?P<pk>\d+)/for-review/?$', view=views.FeedbackListForReviewService.as_view()),
    url(r'^subordinates/(?P<login>[\w-]+)/for-review/?$', view=views.FeedbackListForReviewService.as_view()),
    url(r'^supermode/?$', views.DepartmentFeedbackList.as_view()),
    url(r'^supermode/persons/?$', views.DepartmentFeedbackPersonsList.as_view()),
    url(r'^request/?$', views.RequestFeedback.as_view(), name='feedback-suggest'),
    url(r'^request/incoming/?$', views.IncomingRequestList.as_view(), name='feedback-incoming-request'),
    url(r'^request/(?P<id>\d+)/?$', views.RequestDetails.as_view(), name='request-details'),
    url(r'^request/(?P<id>\d+)/resend/?$', views.AskRequest.as_view(), name='request-resend'),
)
