# coding: utf-8
import os
import sys

import yenv
from django.utils import autoreload


def _setup_environ():
    os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'fb.settings')


def django_main():
    _setup_environ()

    from django.core.management import execute_from_command_line

    execute_from_command_line(sys.argv)


def celery_main():
    _setup_environ()
    import django
    from celery.__main__ import main

    django.setup()
    if yenv.type == 'development':
        return autoreload.main(main)
    return main()
