# coding: utf-8
from django.conf import settings
from django.contrib.auth.models import AnonymousUser
from django.contrib.auth import get_user_model
import django_yauth.user
from fb.staff.models import Person


# TODO: узнать, нужно ли это кому-то. Если нет - удалить
class MockAuthMiddleware(object):
    def process_request(self, request):
        User = get_user_model()
        LOGIN_DEBUG_HEADER_NAME = 'HTTP_DEBUG_LOGIN'
        LOGIN_GET_PARAM_NAME = 'debug-login'

        login = None
        uid = 1

        if LOGIN_GET_PARAM_NAME in request.GET:
            login = request.GET[LOGIN_GET_PARAM_NAME]
            uid = Person.objects.get(login=login).uid
        elif LOGIN_DEBUG_HEADER_NAME in request.META:
            login = request.META[LOGIN_DEBUG_HEADER_NAME]
            uid = Person.objects.get(login=login).uid
        elif request.user.is_authenticated():
            return

        if login is None:
            request.yauser = django_yauth.user.AnonymousYandexUser()
            request.user = AnonymousUser()
        else:
            request.yauser = django_yauth.user.YandexUser(
                uid=uid,
                is_lite=False,
                fields={'login': login},
                need_reset=False,
                emails=[],
                default_email=login + '@yandex-team.ru',
                new_session=False,
            )
            request.user = User.objects.get(username=login)
        if getattr(settings, 'YAUTH_USE_NATIVE_USER', None):
            request.__class__.user = django_yauth.user.DjangoUserDescriptor()
