# coding: utf-8
from __future__ import unicode_literals

from django.contrib import admin

from fb.quizz import models


@admin.register(models.Quizz)
class QuizzAdmin(admin.ModelAdmin):

    def get_queryset(self, request):
        queryset = super(QuizzAdmin, self).queryset(request)
        queryset = queryset.prefetch_related(
            'owner',
            'quizzgroup_set__group',
        )
        return queryset

    list_display = (
        'id',
        'owner',
        'created',
        'is_published',
        'groups',
    )
    list_filter = (
        'is_published',
        'created',
    )
    search_fields = (
        'owner__login',
    )

    raw_id_fields = (
        'owner',
    )

    def groups(self, obj):
        return ', '.join([
            quizz_group.group.machine_name
            for quizz_group in obj.quizzgroup_set.all()
        ])


@admin.register(models.QuizzQuestion)
class QuizzQuestionAdmin(admin.ModelAdmin):
    list_display = (
        'id',
        'quizz_id',
        'question_type',
        'question_for',
        'position',
        'text',
        'description',
    )

    list_filter = (
        'question_type',
        'question_for',
        'quizz__id',
    )
    search_fields = (
        'text',
        'description',
    )
    raw_id_fields = (
        'quizz',
    )

    def quizz_id(self, obj):
        return obj.quizz_id


@admin.register(models.QuizzQuestionAnswer)
class QuizzQuestionAnswerAdmin(admin.ModelAdmin):

    def get_queryset(self, request):
        queryset = super(QuizzQuestionAnswerAdmin, self).queryset(request)
        queryset = queryset.prefetch_related(
            'question',
        )
        return queryset

    list_display = (
        'id',
        'quizz_id',
        'question_id',
        'is_open',
        'text',
    )
    search_fields = (
        'text',
    )
    raw_id_fields = (
        'question',
    )
    list_filter = (
        'is_open',
        'question__id',
    )

    def question_id(self, obj):
        return obj.question_id

    def quizz_id(self, obj):
        return obj.question.quizz_id


@admin.register(models.PersonAnswer)
class PersonAnswerAdmin(admin.ModelAdmin):
    list_display = (
        'id',
        'person',
        'on_whom',
        'feedback_id',
    )
    fields = readonly_fields = list_display

    def feedback_id(self, obj):
        return obj.feedback_id
