# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import models, migrations


class Migration(migrations.Migration):

    dependencies = [
        ('staff', '0007_groupdetails_machine_name'),
    ]

    operations = [
        migrations.CreateModel(
            name='PersonAnswer',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('text', models.TextField(max_length=255, blank=True)),
                ('on_whom', models.ForeignKey(related_name=b'answers_about', to='staff.Person')),
                ('person', models.ForeignKey(related_name=b'answers_from', to='staff.Person')),
            ],
            options={
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='Quizz',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('created', models.DateField(auto_now_add=True)),
                ('is_published', models.BooleanField(default=True)),
                ('owner', models.ForeignKey(to='staff.Person')),
            ],
            options={
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='QuizzGroup',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('include_subdepartments', models.BooleanField(default=False)),
                ('group', models.ForeignKey(to='staff.GroupDetails', unique=True)),
                ('quizz', models.ForeignKey(to='quizz.Quizz')),
            ],
            options={
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='QuizzQuestion',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('question_type', models.IntegerField(default=0, choices=[(0, 'multichoice'), (1, 'singlechoice'), (2, 'competence'), (3, 'openanswer')])),
                ('question_for', models.IntegerField(default=0, choices=[(0, 'head'), (1, 'subordinated'), (2, 'customer'), (3, 'contractor'), (4, 'colleague')])),
                ('text', models.TextField()),
                ('description', models.TextField()),
                ('position', models.IntegerField()),
                ('quizz', models.ForeignKey(to='quizz.Quizz')),
            ],
            options={
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='QuizzQuestionAnswer',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('text', models.CharField(max_length=255)),
                ('is_open', models.BooleanField(default=False)),
                ('question', models.ForeignKey(to='quizz.QuizzQuestion')),
            ],
            options={
            },
            bases=(models.Model,),
        ),
        migrations.AlterUniqueTogether(
            name='quizzgroup',
            unique_together=set([('quizz', 'group')]),
        ),
        migrations.AddField(
            model_name='personanswer',
            name='quizz_answer',
            field=models.ForeignKey(to='quizz.QuizzQuestionAnswer'),
            preserve_default=True,
        ),
    ]
