# coding: utf-8
from __future__ import unicode_literals

from django.core.management.base import BaseCommand

from fb.roles.models import PersonRole, GroupRole


class Command(BaseCommand):

    help = "Copies roles from cia to feedback"

    def handle(self, *args, **options):
        fb_role_ids = set(PersonRole.objects.values_list('id', flat=True))
        cia_roles = list(
            PersonRole.objects
            .using('cia')
            .exclude(id__in=fb_role_ids)
        )
        PersonRole.objects.bulk_create(cia_roles)

        fb_role_ids = set(GroupRole.objects.values_list('id', flat=True))
        cia_roles = list(
            GroupRole.objects
            .using('cia')
            .exclude(id__in=fb_role_ids)
        )
        GroupRole.objects.bulk_create(cia_roles)
