# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import models, migrations


class Migration(migrations.Migration):

    dependencies = [
        ('staff', '0008_person_is_robot'),
    ]

    operations = [
        migrations.CreateModel(
            name='GroupRole',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('project', models.CharField(max_length=255, choices=[(b'review', b'review'), (b'feedback', b'feedback')])),
                ('action', models.CharField(max_length=255, choices=[(b'read', '\u041f\u0440\u043e\u0441\u043c\u043e\u0442\u0440 \u043f\u043e\u0432\u044b\u0448\u0435\u043d\u0438\u0439'), (b'read_salary', '\u041f\u0440\u043e\u0441\u043c\u043e\u0442\u0440 \u043f\u043e\u0432\u044b\u0448\u0435\u043d\u0438\u0439 \u0438 \u0437\u0430\u0440\u043f\u043b\u0430\u0442'), (b'approve', '\u0421\u043e\u0433\u043b\u0430\u0441\u043e\u0432\u0430\u043d\u0438\u0435')])),
                ('is_approved', models.BooleanField(default=False)),
                ('idm_role_id', models.IntegerField(null=True)),
                ('status', models.IntegerField(default=0, choices=[(0, b'User created'), (1, b'Transfering to idm'), (2, b'In idm'), (3, b'Deleting from idm')])),
                ('granter', models.ForeignKey(related_name=b'roles_grouprole_as_granter', to='staff.Person')),
                ('group', models.ForeignKey(related_name=b'roles', to='staff.GroupDetails')),
                ('owner', models.ForeignKey(related_name=b'roles_grouprole_as_owner', to='staff.Person')),
                ('requester', models.ForeignKey(related_name=b'roles_grouprole_as_requester', to='staff.Person')),
            ],
            options={
                'db_table': 'role_grouprole',
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='PersonRole',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('project', models.CharField(max_length=255, choices=[(b'review', b'review'), (b'feedback', b'feedback')])),
                ('action', models.CharField(max_length=255, choices=[(b'read', '\u041f\u0440\u043e\u0441\u043c\u043e\u0442\u0440 \u043f\u043e\u0432\u044b\u0448\u0435\u043d\u0438\u0439'), (b'read_salary', '\u041f\u0440\u043e\u0441\u043c\u043e\u0442\u0440 \u043f\u043e\u0432\u044b\u0448\u0435\u043d\u0438\u0439 \u0438 \u0437\u0430\u0440\u043f\u043b\u0430\u0442'), (b'approve', '\u0421\u043e\u0433\u043b\u0430\u0441\u043e\u0432\u0430\u043d\u0438\u0435')])),
                ('is_approved', models.BooleanField(default=False)),
                ('idm_role_id', models.IntegerField(null=True)),
                ('status', models.IntegerField(default=0, choices=[(0, b'User created'), (1, b'Transfering to idm'), (2, b'In idm'), (3, b'Deleting from idm')])),
                ('granter', models.ForeignKey(related_name=b'roles_personrole_as_granter', to='staff.Person')),
                ('owner', models.ForeignKey(related_name=b'roles_personrole_as_owner', to='staff.Person')),
                ('requester', models.ForeignKey(related_name=b'roles_personrole_as_requester', to='staff.Person')),
                ('subject', models.ForeignKey(related_name=b'roles_personrole_as_subject', to='staff.Person')),
            ],
            options={
                'db_table': 'role_personrole',
            },
            bases=(models.Model,),
        ),
        migrations.AlterUniqueTogether(
            name='personrole',
            unique_together=set([('owner', 'subject', 'granter', 'project', 'action')]),
        ),
        migrations.AlterUniqueTogether(
            name='grouprole',
            unique_together=set([('owner', 'group', 'granter', 'project', 'action')]),
        ),
    ]
