# coding: utf-8
import os
import sys
import json
from copy import deepcopy

import yenv

from blackbox import XmlBlackbox
import datasources_config_wrapper
from django_replicated.settings import *

ds = datasources_config_wrapper.DatasourcesConfigWrapper(
    prefix='feedback',
    suppress_warning=True,
    fallback_on_env_vars=True,
)
if yenv.type == 'development':
    class DevDS(object):
        database_db = 'feedback'
        database_user = 'feedback'
        database_password = 'feedback'
        database_cia_db = 'feedback'
        database_cia_user = 'feedback'
        database_cia_password = 'feedback'
        database_host_master = 'mysql'
        database_port_master = '3306'
        database_host_slave = 'mysql'
        database_port_slave = '3306'
        mongodb_db = 'feedback'
        mongodb_hosts = 'mongo'
        mongodb3_user = ''
        mongodb3_user_password = ''
        # Переопределяется в /etc/yandex/tools-datasources/datasources.py
        oauth_secret = ds.oauth_secret
        robot_token = ds.robot_token
        django_secret_key = ds.django_secret_key
        yt_token = ''

    ds = DevDS()


BASE_DIR = os.path.dirname(os.path.dirname(__file__))

path = lambda x: os.path.join(BASE_DIR, x)


SECRET_KEY = ds.django_secret_key

DEBUG = False

TEMPLATE_DEBUG = DEBUG

ALLOWED_HOSTS = ['.yandex.ru', '.yandex-team.ru']

USER = os.environ.get('USER', '')
HOST = yenv.choose_key_by_type({
    'production': 'fb.yandex-team.ru',
    'testing': 'fb.test.yandex-team.ru',
    'development': 'fb-%s.femida.dev.yandex-team.ru' % USER,
})

FEEDBACK_OAUTH_ID = '12f25b02f27243c9a3d229daf28d8b7f'
FEEDBACK_OAUTH_SECRET = ds.oauth_secret
FEEDBACK_ROBOT_TOKEN = ds.robot_token
ROBOT_TOKEN = FEEDBACK_ROBOT_TOKEN

TEMPLATE_DIRS = (
    path('templates'),
)

ADMINS = (
    ('Dmitry Terrov', 'terrmit@yandex-team.ru'),
    ('Wladimir Spasskiy', 'wlame@yandex-team.ru'),
)

# Application definition

INSTALLED_APPS = (
    'django.contrib.admin',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.messages',
    'django.contrib.staticfiles',

    'django_yauth',
    'rest_framework',
    'corsheaders',
    'django_idm_api',

    'fb',
    'fb.staff',
    'fb.feedback',
    'fb.common',
    'fb.quizz',
    'fb.cia',
    'fb.roles',
)

# Database

from cia_stuff import settings as common_settings
COMMON_SETTINGS = common_settings.get_settings(configured=locals())

DATABASE_ROUTERS = COMMON_SETTINGS.DATABASE_ROUTERS
DATABASES = COMMON_SETTINGS.DATABASES

# FIXME: временно ходим сразу в 2 БД: fb и cia
DATABASES['cia'] = dict(
    deepcopy(DATABASES['default']),
    NAME=ds.database_cia_db,
    USER=ds.database_cia_user,
    PASSWORD=ds.database_cia_password,
)

# TODO: hotfix. Somehow service unexpecting drops connections. It leads to 500 answers
for v in DATABASES.values():
    v['CONN_MAX_AGE'] = int(os.getenv('FB_CONN_MAX_AGE', 0))
    v['OPTIONS'].update({'charset': 'utf8mb4'})

REPLICATED_DATABASE_SLAVES = COMMON_SETTINGS.REPLICATED_DATABASE_SLAVES
REPLICATED_DATABASE_DOWNTIME = COMMON_SETTINGS.REPLICATED_DATABASE_DOWNTIME
REPLICATED_CHECK_STATE_ON_WRITE = COMMON_SETTINGS.REPLICATED_CHECK_STATE_ON_WRITE
REPLICATED_VIEWS_OVERRIDES = {'yauth-create-profile': 'master'}


MIDDLEWARE_CLASSES = [
    'fb.cia.middleware.AliveMiddleware',
    'fb.cia.middleware.ReadOnlyMiddleware',
    'django_replicated.middleware.ReplicationMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'corsheaders.middleware.CorsMiddleware',
    'django.middleware.gzip.GZipMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'fb.cia.middleware.CustomYauthMiddleware',
    'fb.staff.middleware.SetStaffUserInRequest',
    'fb.cia.middleware.SetRolesFromCIA',
    'cia_stuff.common.log.ContextLoggingMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',
    'django.middleware.locale.LocaleMiddleware',
    'fb.cia.middleware.UwsgiLogMiddleware',
]

ROOT_URLCONF = 'fb.urls'

WSGI_APPLICATION = 'fb.wsgi.application'


LANGUAGE_CODE = 'en-us'

TIME_ZONE = 'Europe/Moscow'
CELERY_TIMEZONE = 'Europe/Moscow'

USE_L10N = True

USE_TZ = True


STATIC_URL = '/static/'
STATIC_ROOT = '/static/'

LOCALE_PATHS = (
    path('locale'),
)

# Django Yauth settings:
from django_yauth.settings import *
YAUTH_USE_SITES = False
YAUTH_TYPE = 'intranet'
YAUTH_CREATION_REDIRECT = True
YAUTH_USE_NATIVE_USER = True
YAUTH_BLACKBOX_INSTANCE = XmlBlackbox(XmlBlackbox.URLS['intranet']['production'])
YAUTH_MECHANISMS = [
    'django_yauth.authentication_mechanisms.tvm',
    'django_yauth.authentication_mechanisms.cookie',
    'django_yauth.authentication_mechanisms.oauth',
]

TVM_CLIENT_ID = os.getenv('TVM_CLIENT_ID')
TVM_APPLICATIONS = yenv.choose_key_by_type({
    'production': {'feedback': 2019223, 'idm': 2001600},
    'testing':  {'feedback': 2019221, 'idm': 2001602},
    'development': {},
})

YAUTH_TVM2_ALLOWED_CLIENT_IDS = []
YAUTH_TVM2_CLIENT_ID = 0
YAUTH_TVM2_SECRET = os.getenv('YAUTH_TVM2_SECRET', '')

YAUTH_TVM2_CLIENT_ID = TVM_CLIENT_ID

YAUTH_TVM2_ALLOWED_CLIENT_IDS = TVM_APPLICATIONS.values()

STAFF_TOKEN = ds.robot_token

DEFAULT_FROM_EMAIL = 'robot-feedback@yandex-team.ru'
DEBUG_EMAIL = 'mtest@yandex-team.ru'
EMAIL_HOST_USER = 'robot-feedback@yandex-team.ru'
EMAIL_HOST = 'outbound-relay.yandex.net'
EMAIL_PORT = 25
EMAIL_TIMEOUT = 10

BANNED_EMAIL_RECIPIENTS = []

BASE_URL = 'https://feedback.yandex-team.ru'

INFLECTOR_HOST = 'hamzard.yandex.net'
INFLECTOR_PORT = 8891

DEBUG_TOOLBAR_CONFIG = {
    'SHOW_TOOLBAR_CALLBACK': 'fb.mock.debug_toolbar_callback',
}

SEND_REAL_MESSAGES = False

MONGO_HOSTS = ds.mongodb_hosts
MONGO_DATABASE = ds.mongodb_db
MONGO_USER = ds.mongodb3_user
MONGO_PASSWORD = ds.mongodb3_user_password

BROKER_URL = 'mongodb://{}/{}'.format(
    MONGO_HOSTS,
    MONGO_DATABASE,
)
BROKER_USER = MONGO_USER
BROKER_PASSWORD = MONGO_PASSWORD

CELERY_WORKER_DIRECT = True
CELERY_ACCEPT_CONTENT = ['json']
CELERY_TASK_SERIALIZER = 'json'
CELERY_RESULT_SERIALIZER = 'json'


CELERY_QUEUE = 'feedback-queue'
CELERY_DEFAULT_QUEUE = CELERY_QUEUE
CELERY_DEFAULT_ROUTING_KEY = CELERY_QUEUE


SECURE_PROXY_SSL_HEADER = ('HTTP_X_FORWARDED_PROTO', 'https')


from celery.schedules import crontab

CELERYBEAT_SCHEDULE = {
    'load-new-staff-persons': {
        'task': 'fb.staff.tasks.load_persons_from_staff',
        'schedule': crontab(hour='4', minute='10'),
    },
    'send-feedback-request-reminders': {
        'task': 'fb.feedback.tasks.send_feedback_request_reminders',
        'schedule': crontab(hour='4', minute='40'),
    },
}

YT_TOKEN = ds.yt_token
YLOCK = {
    'backend': 'yt',
    'prefix': '//home/cia/feedback/{}'.format(yenv.type),
    'token': YT_TOKEN,
}

LOGGING = {
    'version': 1,
    'disable_existing_loggers': False,
    'formatters': {
        'json': {
            '()': 'ylog.format.QloudJsonFormatter',
        },
        'verbose': {
            '()': 'ylog.context.ContextFormatter',
            'datefmt': '%Y-%m-%d %H:%M:%S',
            'format': '[%(asctime)s][%(name)s] - %(levelname)s - %(message)s',
        },
    },
    'handlers': {
        'default': {
            'class': 'logging.StreamHandler',
            'formatter': 'json',
            'stream': sys.stdout,
            'level': 'DEBUG',
        },
    },
    'loggers': {
        'django.request': {
            'handlers': ['default'],
            'level': 'WARNING',
            'propagate': False,
        },
        'django.db.backends': {
            'handlers': ['default'],
            'level': 'WARNING',
            'propagate': False,
        },
        'django_yauth': {
            'handlers': ['default'],
            'level': 'INFO',
            'propagate': False,
        },
        'fb': {
            'handlers': ['default'],
            'level': 'INFO',
            'propagate': False,
        },
    },
    'root': {
        'handlers': ['default'],
        'level': 'INFO',
    },
}

CELERYD_HIJACK_ROOT_LOGGER = False


import requests
from requests.packages.urllib3.exceptions import InsecureRequestWarning


requests.packages.urllib3.disable_warnings(InsecureRequestWarning)

USE_X_FORWARDED_HOST = True

REST_FRAMEWORK = {
    'DEFAULT_AUTHENTICATION_CLASSES': (
        'rest_framework.authentication.SessionAuthentication',
    ),
    'DEFAULT_PERMISSION_CLASSES': (
        'rest_framework.permissions.IsAuthenticated',
        'fb.common.permissions.OAuthClientPermission',
    ),
}

# CORS:
CORS_ORIGIN_ALLOW_ALL = False
CORS_ORIGIN_WHITELIST = []
CORS_ALLOW_CREDENTIALS = True
CORS_ALLOW_METHODS = [
    'GET',
]

CIA_BASE_URL = 'https://cia.yandex-team.ru/'
USE_FAKE_CIA = False
CIA_CERTS = None

INTERNAL_ROOT_CA = '/etc/ssl/certs/YandexInternalRootCA.pem'


def get_redis_cache_settings(cluster_name, db=0):
    REDIS_HOST = os.environ.get('REDIS_HOST', '').split(',')
    REDIS_PORT = os.environ.get('REDIS_PORT', 26379)

    return {
        'default': {
            'BACKEND': 'django_redis.cache.RedisCache',
            'LOCATION': '{name}/{hosts}/{db}'.format(
                name=cluster_name,
                hosts=','.join(['{host}:{port}'.format(host=host, port=REDIS_PORT) for host in REDIS_HOST]),
                db=db,
            ),
            'OPTIONS': {
                'CLIENT_CLASS': 'fb.utils.redis.SentinelClient',
                'IGNORE_EXCEPTIONS': True,
                'PASSWORD': os.environ.get('REDIS_PASSWORD'),
            },
            'KEY_PREFIX': 'feedback',
        }
    }


STAFF_API_BASE_URL = 'https://staff-api.yandex-team.ru/v3/'

OAUTH_REVIEW_CLIENT_ID = 'd04244bac9624917b22016a15b60a8a0'
OAUTH_REVIEW_TEST_CLIENT_ID = 'a2e78d35ce4c4337a7fde113985d3cda'
OAUTH_FRONTEND_BOOTCAMP_TOOLS_CLIENT_ID = '5dae1ac24e414f828b5e4318c439f92a'

ALLOWED_OAUTH_CLIENTS = [
    OAUTH_REVIEW_CLIENT_ID,
    OAUTH_FRONTEND_BOOTCAMP_TOOLS_CLIENT_ID,
]
if yenv.type != 'production':
    ALLOWED_OAUTH_CLIENTS.append(
        # чтобы ходить под другими уидами
        OAUTH_REVIEW_TEST_CLIENT_ID,
    )


ROLES_HOOKS = 'fb.cia.hooks.choose'
