import os
from .settings_default import *

DEBUG = True

TEMPLATE_DEBUG = DEBUG

DATABASES = {
    'default': DATABASES['default'],
}
REPLICATED_DATABASE_SLAVES = []

SECRET_KEY = 'suchsecret'

BASE_URL = 'https://fb.femida.dev.yandex-team.ru'
IMAP_FOLDER = 'DEV'

# CORS
CORS_ORIGIN_ALLOW_ALL = True

CORS_ORIGIN_WHITELIST = [
    'review.femida.dev.yandex-team.ru',
]

auth_middleware_idx = MIDDLEWARE_CLASSES.index('fb.cia.middleware.CustomYauthMiddleware')
MIDDLEWARE_CLASSES[auth_middleware_idx] = 'django_yauth.middleware.YandexAuthTestMiddleware'


INTERNAL_ROOT_CA = None
CIA_BASE_URL = 'https://cia.femida.dev.yandex-team.ru/'
USE_FAKE_CIA = False


if DEBUG:
    INSTALLED_APPS += (
        'rest_framework_swagger',
        'debug_toolbar.apps.DebugToolbarConfig',
        'debug_panel',
    )

if DEBUG:
    gzip_index = MIDDLEWARE_CLASSES.index('django.middleware.gzip.GZipMiddleware')
    MIDDLEWARE_CLASSES = MIDDLEWARE_CLASSES[:gzip_index + 1] + [
        # should be after gzip
        'debug_panel.middleware.DebugPanelMiddleware'
    ] + MIDDLEWARE_CLASSES[gzip_index + 1:]

GOALS_BASE_URL = "https://goals.femida.dev.yandex-team.ru/"
STAFF_API_BASE_URL = 'https://staff-api.test.yandex-team.ru/v3/'


LOGGING['handlers']['default'] = {
    'class': 'logging.StreamHandler',
    'level': 'DEBUG',
    'formatter': 'verbose',
}
LOGGING['loggers']['fb']['level'] = 'DEBUG'


YAUTH_TEST_APPLICATION = OAUTH_REVIEW_TEST_CLIENT_ID
YAUTH_TEST_LOGIN = os.environ.get('USER', 'admin')
YAUTH_TEST_USER = {
    'login': YAUTH_TEST_LOGIN,
    'uid': os.environ.get('YAUTH_UID', '100500'),
    'default_email': '%s@yandex-team.ru' % YAUTH_TEST_LOGIN,
    'oauth': True,
}

try:
    from local_settings import *
except ImportError:
    pass
