# coding: utf-8
from __future__ import unicode_literals

from django.contrib import admin

from fb.staff import models


@admin.register(models.Person)
class PersonAdmin(admin.ModelAdmin):
    list_display = (
        'login',
        'first_name_ru',
        'last_name_ru',
        'official_position_ru',
        'is_dismissed',
    )

    readonly_fields = (
        'head',
        'heads',
        'url',
    )
    search_fields = (
        'staff_id',
        'login',
        'first_name_ru',
        'last_name_ru',
        'first_name_en',
        'last_name_en',
    )


@admin.register(models.Group)
class GroupAdmin(admin.ModelAdmin):
    list_display = (
        'path',
        'staff',
    )
    readonly_fields = list_display
    list_select_related = (
        'staff',
    )
    search_fields = (
        'path',
        'staff__name',
        'staff__name_en',
    )


@admin.register(models.GroupDetails)
class GroupDetailsAdmin(admin.ModelAdmin):
    list_display = (
        'name',
        'machine_name',
        'staff_id',
    )
    readonly_fields = list_display
    search_fields = (
        'name',
        'machine_name',
        'staff_id',
    )


@admin.register(models.GroupMembership)
class GroupMembershipAdmin(admin.ModelAdmin):
    list_display = (
        'person',
        'group',
        'is_chief',
        'is_deputy',
        'is_primary',
    )
    readonly_fields = list_display
    search_fields = (
        'person__login',
        'group__machine_name',
    )
