from django.core.urlresolvers import reverse
from django.conf import settings

from fb.staff.mixins import HRDepartmentsMixin
from fb.staff.models import Person


class SetStaffUserInRequest(HRDepartmentsMixin, object):
    def process_request(self, request):
        if request.path == reverse(settings.YAUTH_CREATE_PROFILE_VIEW):
            return None

        try:
            request.owner = Person.objects.get(uid=request.yauser.uid)

            hr_departments = self.hr_department_instances(request.user)

            request.owner.hr_departments = []
            request.owner.hr_head_departments = []

            for dep in hr_departments:
                chief = dep.get_chief()
                request.owner.hr_head_departments.append(chief)
                request.owner.hr_departments.append(dep)
        except Person.DoesNotExist:
            request.owner = None
