# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import models, migrations
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Group',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('path', models.CharField(unique=True, max_length=255)),
                ('depth', models.PositiveIntegerField()),
                ('numchild', models.PositiveIntegerField(default=0)),
            ],
            options={
                'db_table': 'staff_group',
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='GroupDetails',
            fields=[
                ('name', models.CharField(max_length=255)),
                ('staff_id', models.IntegerField(unique=True, serialize=False, primary_key=True)),
            ],
            options={
                'db_table': 'staff_group_info',
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='GroupMembership',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('is_chief', models.BooleanField(default=False)),
                ('is_deputy', models.BooleanField(default=False)),
                ('group', models.ForeignKey(to='staff.GroupDetails')),
            ],
            options={
                'db_table': 'staff_groupmembership',
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='Person',
            fields=[
                ('staff_id', models.IntegerField(unique=True, serialize=False, primary_key=True)),
                ('uid', models.BigIntegerField()),
                ('login', models.CharField(max_length=50)),
                ('is_dismissed', models.BooleanField(default=False)),
                ('first_name_ru', models.CharField(max_length=50, blank=True)),
                ('last_name_ru', models.CharField(max_length=50, blank=True)),
                ('first_name_en', models.CharField(max_length=50, blank=True)),
                ('last_name_en', models.CharField(max_length=50, blank=True)),
                ('groups', models.ManyToManyField(related_name=b'members', through='staff.GroupMembership', to='staff.GroupDetails')),
            ],
            options={
                'db_table': 'staff_person',
            },
            bases=(models.Model,),
        ),
        migrations.AddField(
            model_name='groupmembership',
            name='person',
            field=models.ForeignKey(to='staff.Person'),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name='group',
            name='staff',
            field=models.OneToOneField(related_name=b'group_structure', on_delete=django.db.models.deletion.DO_NOTHING, db_column=b'staff_id', to='staff.GroupDetails'),
            preserve_default=True,
        ),
    ]
