from fb.staff.models import GroupDetails


class HRDepartmentsMixin(object):

    HR_GOD_GROUP = 'god_hr'

    @staticmethod
    def parse_from_group_name(names):
        for name in names:
            group = name.split('__', 1)
            if len(group) == 2:
                yield group[1]

    def hr_departments(self, django_user):
        names = django_user.groups.filter(
            name__startswith=self.HR_GOD_GROUP
        ).values_list('name', flat=True)
        return list(self.parse_from_group_name(names))

    def hr_department_instances(self, django_user):
        departments = self.hr_departments(django_user)
        return GroupDetails.objects.filter(staff_id__in=departments).all()
