from django.db import models

__all__ = ['GroupMembership']


class GroupMembership(models.Model):

    class Meta:
        app_label = 'staff'
        db_table = 'staff_groupmembership'

    group = models.ForeignKey('staff.GroupDetails')
    person = models.ForeignKey('staff.Person')
    is_chief = models.BooleanField(default=False)
    is_deputy = models.BooleanField(default=False)
    is_primary = models.BooleanField(default=False)
